/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 22 03:30:25 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.util.*;

import ix.icore.domain.PatternAssignment;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

public class WorldStateView {

    public static final Symbol TRUE = Symbol.intern("true");
    public static final Symbol EQ = Symbol.intern("=");

    protected String name;
    protected List filterPatterns;
    protected List filters;	// List<Filter>

    public WorldStateView() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getFilterPatterns() {
        return filterPatterns;
    }

    public void setFilterPatterns(List filterPatterns) {
        this.filterPatterns = filterPatterns;
	this.filters = createFilters(filterPatterns);
    }

    public List getFilters() {
	return filters;
    }

    public boolean isIncluded(PatternAssignment pv) {
	return isIncluded(pv.getPattern(), pv.getValue());
    }

    public boolean isIncluded(LList pattern, Object value) {
	if (filters == null || filters.isEmpty())
	    return true;
	else {
	    for (Iterator i = filters.iterator(); i.hasNext();) {
	        Filter filter = (Filter)i.next();
		if (filter.trueOf(pattern, value))
		    return true;
	    }
	    return false;
	}
    }

    List createFilters(List filterPatterns) {
	List result = new LinkedList();
	List badPatterns = new LinkedList();
	for (Iterator i = filterPatterns.iterator(); i.hasNext();) {
	    Object maybe = i.next();
	    if (!(maybe instanceof List)) {
		badPatterns.add(maybe);
		continue;
	    }
	    // Syntax is: pattern [= value]
	    // where pattern is an LList and value defaults to TRUE.
	    LList p = LList.LListify((List)maybe);
	    if (!(p.get(0) instanceof LList))
		badPatterns.add(p);
	    if (p.length() == 1)
		result.add(new Filter((LList)p.get(0), TRUE));
	    else if (p.length() == 3 && p.get(1) == EQ)
		result.add(new Filter((LList)p.get(0), p.get(2)));
	    else
		badPatterns.add(p);
	}
	if (!badPatterns.isEmpty())
	    Debug.warn("Bad patterns in " + this + ": " + badPatterns);
	return result;
    }

    static class Filter {

	LList patternPattern;
	Object valuePattern;

	Filter(LList patternPattern, Object valuePattern) {
	    this.patternPattern = patternPattern;
	    this.valuePattern = valuePattern;
	}

	boolean trueOf(LList p, Object v) {
	    MatchEnv env = SimpleMatcher.match(patternPattern, p);
	    if (env == null)
		return false;
	    else
		return SimpleMatcher.match(valuePattern, v, env) != null;
	}

	public String toString() {
	    return "Filter[" + patternPattern + " = " + valuePattern + "]";
	}

    }

}
