/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 22 03:34:24 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.util.*;

import ix.icore.IXAgent;
import ix.icore.domain.*;

import ix.util.*;
import ix.util.lisp.*;

public class WorldStateExport extends WorldStateView {

    protected String destination;

    public WorldStateExport() {
    }

    public String getDestination() {
	return destination;
    }

    public void setDestination(String destination) {
	this.destination = destination;
    }

    public void handleStateChange(Map delta, IXAgent sender) {
	for (Iterator i = delta.entrySet().iterator(); i.hasNext();) {
	    PatternAssignment pv = new PatternAssignment((Map.Entry)i.next());
	    if (isIncluded(pv)) {
		Debug.noteln("Will send " + pv + " to " + destination);
		Constraint effect =
		    new Constraint("world-state", "effect", Lisp.list(pv));
		send(sender, effect);
	    }
	}
    }

    void send(IXAgent sender, Constraint effect) {
        Name ourName = Name.valueOf(sender.getAgentIPCName());
	effect.setSenderId(ourName);
	IPC.sendObject(destination, effect);
    }

}
