/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr 23 13:50:42 2009 by Jeff Dalton
 * Copyright: (c) 2009, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.net.URL;

/**
 * Represents a Second Life / Opensim virtual world for communication
 * via HTTP etc.
 */
public class VirtualWorld {

    protected String name;
    protected String shard;     		// regexp
    protected int httpLengthLimit = 2048;
    protected URL xmlRpcUrl;

    public VirtualWorld() {
    }

    public VirtualWorld(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShard() {
        return shard;
    }

    public void setShard(String shard) {
        this.shard = shard;
    }

    public int getHttpLengthLimit() {
        return httpLengthLimit;
    }

    public void setHttpLengthLimit(int httpLengthLimit) {
        this.httpLengthLimit = httpLengthLimit;
    }
    public URL getXmlRpcUrl() {
        return xmlRpcUrl;
    }

    public void setXmlRpcUrl(URL xmlRpcUrl) {
        this.xmlRpcUrl = xmlRpcUrl;
    }

    public String toString() {
        return "VirtualWorld[" + name + "]";
    }

}
