/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat May 10 11:46:00 2008 by Jeff Dalton
 * Copyright: (c) 2003, 2008, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.util.*;

import ix.util.*;

/**
 * A possibly useful Map-like class.
 *
 * @see MapEntry
 * @see ix.util.lisp.EqMap
 */
public class Mapping {

    protected ListOfMapEntry entries;

    public Mapping() {
    }

    public Mapping(Map m) {
	entries = new LinkedListOfMapEntry();
	for (Iterator i = m.keySet().iterator(); i.hasNext();) {
	    Object key = i.next();
	    entries.add(new MapEntry(key, m.get(key)));
	}
    }

    public ListOfMapEntry getEntries() {
	return entries;
    }

    public Object get(Object key) {
	MapEntry e = getEntry(key);
	return e == null ? null : e.getValue();
    }

    protected MapEntry getEntry(Object key) {
	for (MapEntry e: entries) {
	    if (e.getKey().equals(key))
		return e;
	}
	return null;
    }

    public void setEntries(ListOfMapEntry entries) {
	this.entries = entries;
    }

    public Object put(Object key, Object value) {
	MapEntry e = getEntry(key);
	if (e != null) {
	    Object oldValue = e.getValue();
	    e.setValue(value);
	    return oldValue;
	}
	else {
	    entries.add(new MapEntry(key, value));
	    return null;
	}
    }

    public Map toMap() {
	return toMap(new HashMap());
    }

    public Map toMap(Map m) {
	if (entries == null)
	    return m;
	for (MapEntry e: entries) {
	    m.put(e.getKey(), e.getValue());
	}
	return m;
    }

}
