/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Nov 19 18:14:58 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.test;

import java.io.*;

import ix.util.*;

public class WithCleanupTest {

    public static void main(String[] argv) {
	// Check that body() and cleanup() methods don't need
	// a "throws" clause.
	new WithCleanup() {
	    public void body() {}
	    public void cleanup() {}
	};
	// Test 1 - an exception only in the body.
	try { test1(); }
	catch (Throwable t) {
	    Debug.displayException(t);
	}
	// Test 2 - an exception only in cleanup.
	try { test2(); }
	catch (Throwable t) {
	    Debug.displayException(t);
	}
	// Test 3 - two expcetions
	try { test3(); }
	catch (Throwable t) {
	    Debug.displayException(t);
	}
	System.exit(1);
    }

    private static void test1() {
	IO.withClosable(new PipedReader(), new Runnable() {
	    public void run() {
		throw new RuntimeException("No problem");
	    }
	});
    }

    private static void test2() {
	IO.withClosable("Not closeable", new Runnable() {
	    public void run() {
		;		// no 1st exception
	    }
	});
    }

    private static void test3() {
	IO.withClosable("Not closeable", new Runnable() {
	    public void run() {
		throw new RuntimeException("No problem");
	    }
	});
    }

}
