/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Sep 25 00:00:05 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.awt.event.*;
import javax.swing.*;

import java.util.*;

import ix.ip2.Ip2;
import ix.ispace.ISpaceTool;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IFUtil;

import ix.icore.*;
import ix.util.ipc.WrapperStrategy;
import ix.util.*;

/**
 * A comm strategy that can be edited to test various things.
 */
public class TestStrategy extends WrapperStrategy {

    public TestStrategy() {
	super();
    }

    public void sendObject(Object destination, Object contents) {
        super.sendObject(destination, contents);
    }

    public void setupServer(Object destination,
                            IPC.MessageListener listener) {
        super.setupServer(destination, listener);

	// Get the agent's I-Space tool.
	IXAgent agent = IXAgent.getAgent();
	ISpaceTool ispace = (ISpaceTool)agent.ensureTool("I-Space");

	// Add a menu to the I-Space tool.
	JMenu example = new JMenu("Example Menu");
	ispace.addMenu(example);
	example.add(IFUtil.makeMenuItem("Boo!", new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		Util.displayAndWait(null, "Boo!");
	    }
	}));

	// Add a tab to the I-Space tool.
	ispace.addTab("Example tab", new JPanel());

    }

}
