/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Aug 17 20:12:02 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import javax.swing.*;
import java.util.*;

import ix.icore.IXAgent;
import ix.util.*;
import ix.util.xml.*;

/**
 * A test to demonstrate that a "modal" dialog does not block
 * something requested via SwingUtilities.invokeLater.  Note
 * that it does block use of the frame's "File" menu.
 */
public class SwingLaterTest {

    public static void main(String[] argv) {

	// /\/: Because a TextAreaFrame uses a ToolFrame, there
	// has to be an agent.
	IXAgent agent = new IXAgent() { };

	final TextAreaFrame tf = new TextAreaFrame("Test Frame") {
	    public void whenClosed() {
		System.exit(0);
	    }
	};

	new Thread() {
	    public void run() {
		while (true) {
		    Util.displayAndWait(tf.getFrame(), "Random Message");
		}
	    }
	}.start();

	int count = 0;
	while (true) {
	    try { Thread.sleep(2000); } catch (Exception e) { }
	    final String line = ++count + " Do you see this?";
	    SwingUtilities.invokeLater(new Runnable() {
		public void run() {
		    tf.appendLine(line);
		}
	    });
	}

    }

}
