/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Mar 28 18:32:13 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.test;

import java.awt.Component;
import java.util.*;

import ix.icore.IXAgentExtension;
import ix.icore.process.event.*;

import ix.test.xml.WorldStateExport;

import ix.ip2.*;
import ix.util.*;
import ix.util.xml.XML;

/**
 * Adds a state-exporter to an I-X Process Panel.
 */
public class StateExportExtension implements IXAgentExtension {

    Ip2 ip2;
    StateExporter exporter;
    List exportList;		// List<WorldStateExport>

    public StateExportExtension(Ip2 ip2) {
	this.ip2 = ip2;
    }

    public void installExtension() {
	this.exporter = new StateExporter();
	ip2.getModelManager().addProcessStatusListener(exporter);
	ip2.addResetHook(new ResetHook());

	String exportsFile = Parameters.getParameter("state-export-list");
	if (exportsFile != null) {
	    Object exports = XML.readObject(exportsFile);
	    if (exports instanceof List
		  && Collect.every((List)exports,
				   Fn.isInstanceOf(WorldStateExport.class)))
		exportList = (List)exports;
	    else
		Debug.warn(exportsFile + " did not contain a " +
			   "list of world-state-exports.");
	}
	if (exportList != null) {
	    // Describe the exports
	    for (Iterator i = exportList.iterator(); i.hasNext();) {
		WorldStateExport e = (WorldStateExport)i.next();
		Debug.noteln("Exporting to", e.getDestination());
		for (Iterator j = e.getFilters().iterator(); j.hasNext();) {
		    Debug.noteln("   ", j.next());
		}
	    }
	}
    }

    class ResetHook implements Runnable {
	public void run() {
	    Debug.noteln("Resetting", exporter);
	    exporter.reset();
	}
    }

    class StateExporter implements StateViewer {

	/* Methods from the StateViewer interface */

	public Component getView(PanelFrame panelFrame) {
	    throw new UnsupportedOperationException("getView");
	}

	public void reset() {
	}

	/* ProcessStatusListener methods */

	/** Ignored by this viewer. */
	public void statusUpdate(ProcessStatusEvent event) { }

	/** Ignored by this viewer. */
	public void newBindings(ProcessStatusEvent event, Map bindings) { }

	public void stateChange(ProcessStatusEvent event, Map delta) {
	    Debug.noteln("State to consider exporting", delta);
	    if (exportList == null)
		return;
	    for (Iterator i = exportList.iterator(); i.hasNext();) {
		WorldStateExport e = (WorldStateExport)i.next();
		e.handleStateChange(delta, ip2);
	    }
	}

	public void stateDeletion(ProcessStatusEvent event, Map delta) {
	    // /\/: Ignore for now.
	}

	/* End of ProcessStatusListener methods */

    }

}
