/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 12 20:49:43 2003 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.test;

import ix.icore.IXAgent;

import ix.iface.util.ToolController;

import ix.util.*;

/**
 * An example of a very simple I-X agent.  Its IPC name can be given
 * by the "-ipc-name" command-line argument.  For example, to pretend
 * to be I-TEST
 * <pre>
 *    java ix.test.SimpleIXAgent -ipc -ipc-name=ITEST
 * </pre>
 *
 * @see <a 
 *       href="../../../../java/ix/test/SimpleIXAgent.java">SimpleIXAgent.java 
 *       source code</a>
 */
public class SimpleIXAgent extends IXAgent {

    public SimpleIXAgent() {
	super();
    }

    protected void processCommandLineArguments() {
	super.processCommandLineArguments();
    }

    protected void startup() {
	// This is optional.  We could just let the first incoming message
	// cause the text frame to be created.  But this way we can make it
	// appear right away and can add an "Exit" button.

	textFrame = new TextAreaFrame("Messages for " + ipcName,
				      new String[] { "Exit" } );

	textFrame.addToolManager();

	textFrame.addListener(new TextAreaFrame.TListener() {
	    public void buttonPressed(String action) {
		if (action.equals("Exit"))
		    System.exit(0);
	    }
	});

    }

    public void addTool(ToolController tc) {
	textFrame.addTool(tc);
    }

    public static void main(String[] argv) {

	Util.printGreeting("Simple I-X Agent");

	new SimpleIXAgent().mainStartup(argv);

    }

}

