/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 12 15:25:37 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import ix.icore.*;
import ix.iquery.*;
import ix.util.*;

/**
 * An example of a very simple I-Q agent.
 */
public class SimpleIQuery extends IQuery {

    public SimpleIQuery() {
        super();
    }

    public static void main(String[] argv) {
        Util.printGreeting("Simple I-Q Example");
        new SimpleIQuery().mainStartup(argv);
    }

    protected boolean isLookupActivity(Activity activity) {
        return activity.getPattern().get(0).toString().equals("lookup");
    }

    protected LookupHandler
              makeLookupHandler(IQuery queryAgent,
                                Activity lookupActivity) {
        return new ExampleLookupHandler(queryAgent, lookupActivity);
    }

    static class ExampleLookupHandler extends LookupHandler {

        ExampleLookupHandler(IQuery queryAgent, Activity lookupActivity) {
            super(queryAgent, lookupActivity);
        }

        protected void handleLookup() {
            try {
		sendReport(ReportType.PROGRESS, "Started " + lookupActivity);
		Util.sleepSeconds(3);
                sendReport(ReportType.SUCCESS, "Finished " + lookupActivity);
            }
            catch (Exception e) {
                Debug.displayException(e);
                sendReport(ReportType.FAILURE,
                           "Problem: " + Debug.describeException(e));
            }
        }

    }

}
