/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Feb  3 13:29:57 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.security.*;
import java.util.*;

import ix.util.*;

public class SecureRandomTest {

    public static void main(String[] argv) {

	FutureValue getRandom = new FutureRandom();

	// Start thread that will get a random long.
	getRandom.start();
	Thread.yield();
	
	// In the meantime, list all services
	Provider[] providers = Security.getProviders();
	for (int i = 0; i < providers.length; i++) {
	    Debug.noteln(providers[i].toString());
	    Set keys = providers[i].keySet();
	    for (Iterator k = keys.iterator(); k.hasNext();) {
		Debug.noteln("  ", k.next());
	    }
	}

	Debug.noteln("Random long " + getRandom.getValue());

    }

    public static class FutureRandom extends FutureValue {

	public FutureRandom() {
	    super("Get secure random");
	}

	public Object computeValue() {
	    try {
		Debug.noteln("Started FutureRandom", this);
		SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
		Debug.noteln("Have generator", random);
		Long r = new Long(random.nextLong());
		Debug.noteln("Have secure random long", r);
		return r;
	    }
	    catch (NoSuchAlgorithmException e) {
		throw new RethrownException(e);
	    }
	}

    }

}
