/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Aug 30 01:17:56 2004 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;
import java.io.*;
import java.net.*;

import ix.util.*;
import ix.util.lisp.*;

import ix.util.xml.XML;

public class ReadURLTest {

    public static void main(String[] argv) throws IOException {

	Parameters.processCommandLineArguments(argv);

	URL url;
	if (Parameters.haveParameter("name")) {
	    // Try it in turn as URL, file name, and resource.
	    String name = Parameters.getParameter("name");
	    // url = toURL(name);
	    url = XML.toURL(name);
	    if (url == null)
		throw new IllegalArgumentException
		    ("Don't know how to read " + name);
	}
	else if (Parameters.haveParameter("file")) {
	    String fileName = Parameters.getParameter("file");
	    // url = new File(fileName).toURI().toURL();
	    url = new File(fileName).toURL();
	}
	else if (Parameters.haveParameter("url")) {
	    url = new URL(new URL("file:./"),
			  Parameters.getParameter("url"));
	}
	else {
	    System.err.println
		("Must specify -name=name or -file=name or -url=name");
	    return;
	}

	Debug.noteln("Reading from", url);

	URLConnection conn = url.openConnection();
	InputStream stream = conn.getInputStream();
	String encoding = conn.getContentEncoding();
	if (encoding == null)
	    read(new InputStreamReader(stream));
	else 
	    read(new InputStreamReader(stream ,encoding));
    }

    static URL toURL(String name) throws MalformedURLException {
	try {
	    // If it looks enough like a URL, assume it is.
	    return new URL(name);
	}
	catch(MalformedURLException e) {
	    // Try it as a file name.
	    File file = new File(name);
	    if (file.exists()) {
		return file.toURL();
	    }
	    else {
		// Maybe it's a resource
		return ReadURLTest.class.getClassLoader().getResource(name);
	    }
	}
    }

    static void read(Reader r) throws IOException {
	BufferedReader in = new BufferedReader(r);
	
	String line;
	while ((line = in.readLine()) != null) {
	    System.out.println(line);
	}
    }

}
