/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Jun 21 16:05:16 2003 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.test;

import java.awt.event.*;
import java.util.*;

import javax.swing.*;

import ix.icore.*;
import ix.ip2.*;
import ix.util.*;
import ix.util.lisp.*;


/**
 * A version of Ip2 used to test and debug/
 */

public class Ip2Test extends Ip2 {

    Object currentInput = null;

    public Ip2Test() {
	super();

	// Change some defaults
	displayName = "Ip2 Test";
	symbolName = "Test";
	logoLine1 = "Test I-X Process Panel";
	logoLine2 = "Based on I-X Technology";
	logoImage = "ip2-logo.gif";

    }

    public static void main(String[] argv) {

	Util.printGreeting("IP2 Test");

	new Ip2Test().mainStartup(argv);

    }

    public synchronized Object getCurrentInput() {
	return currentInput;
    }

    public synchronized void setCurrentInput(Object in) {
	currentInput = in;
    }

    public void handleInput(IPC.InputMessage message) {
	Object oldInput = getCurrentInput();
	Object newInput = message.getContents();
	Debug.noteln("----- Handling", newInput);
	Debug.expect(oldInput == null,
		     "New message before finished with " + oldInput);
	try {
	    setCurrentInput(newInput);
	    super.handleInput(message);
	}
	finally {
	    setCurrentInput(null);
	    Debug.noteln("----- Finished with", newInput);
	}
    }

}
