/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 22 00:03:39 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;
import java.io.*;
import java.net.*;

import ix.util.*;
import ix.util.lisp.*;

/**
 * A class to illustrate a problem with methods called in inner
 * class constructors and redefined in inner-class subclasses.
 */
public class InnerClassTest {

    public static void main(String[] argv) {
	new InnerClassTest().makeSomething();
    }

    InnerClassTest() {
    }

    void makeSomething() {
	new Inner1();		// works
	new Inner2();		// doesn't
    }

    void saySomething(String whatever) {
	Debug.noteln("OK, I'm saying " + whatever);
    }

    class Inner1 {
	Inner1() {
	    doSomething();
	}
	void doSomething() {
	    saySomething("I don't feel like doing anything.");
	}
    }

    class Inner2 extends Inner1 {
	Inner2() {
	    super();
	}
	void doSomething() {
	    Debug.noteln("I'm going to try to say something.");
	    saySomething("I'll do something sometime."); // gets null ptr
	}
    }

}
