/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jul  9 16:14:14 2001 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.test;

import java.io.*;
import java.net.*;
import java.util.*;

import ix.util.lisp.*;

import ix.util.*;

public class IPCTest {

    public static void main(String[] argv) {

	Parameters.processCommandLineArguments(argv);

	String self = Parameters.getParameter("self");
	String other = Parameters.getParameter("other");

	Parameters.checkParameterUse();

	// Set up server side
	IPC.setupServer(self, new IPC.MessageListener() {
		public void messageReceived(IPC.InputMessage message) {
	    }
	});


	// Do client side
	while(true) {
	    final String text = Util.askLine("Send: ");
	    Serializable closure = new Serializable() {
		public String toString() {
		    return "Enclosed string = " + Util.quote(text);
		}
	    };
	    // See what amazing things we can send.
	    IPC.sendObject(other, closure);
	    IPC.sendObject(other, Lisp.list());
	    IPC.sendObject(other, Lisp.list(text, Symbol.intern(text)));
	    LListCollector col = new LListCollector();
	    col.add("c1");
	    col.add(text);
	    IPC.sendObject(other, col);
	}

    }

}
