/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Sep 17 23:30:13 2007 by Jeff Dalton
 * Copyright: (c) 2005, 2007, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.IXAgentExtension;

import ix.ip2.*;

import ix.util.*;
import ix.util.lisp.*;

public class ComputeExtensionExample implements IXAgentExtension {

    Ip2 ip2;

    public ComputeExtensionExample(Ip2 ip2) {
	this.ip2 = ip2;
    }

    public void installExtension() {
	ComputeInterpreter c =
	    ip2.getIp2ModelManager().getComputeInterpreter();
	c.define(new ExampleFunction());
    }

    class ExampleFunction extends Interpreter.JFunction {
	ExampleFunction() {
	    super("example", 1); // function "example" of 1 argument
	}
	public Object applyTo(Object[] args) {
	    Number arg = mustBe(Number.class, args[0]);
	    return Lisp.list("arg =", arg);
	}
    }

}
