/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 25 21:33:35 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2006, AIAI, University of Edinburgh
 */

package ix.itest;

import javax.swing.*;

import java.util.*;

import ix.iface.util.LogoPanel;

import ix.icore.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;		// for test-menu parameter /\/


/**
 * The generic I-TEST class and application main program. <p>
 *
 * Its IPC name can be given by the "-ipc-name" command-line argument.
 * For example, to pretend to be an agent named I-DEEL:
 * <pre>
 *    java ix.itest.Itest -ipc -ipc-name=I-DEEL
 * </pre>
 *
 */
public class Itest extends IXAgent {

    protected ItestFrame frame;

    public Itest() {
	this("I-Test");
    }

    public Itest(String frameTitle) {
	displayName = frameTitle;
    }

    /**
     * Main program.
     */
    public static void main(String[] argv) {
	Util.printGreeting("I-Test");
	new Itest().mainStartup(argv);
    }

    /**
     * Command-line argument processing used by all versions of I-TEST.
     *
     * @see ix.icore.IXAgent#processCommandLineArguments()
     */
    protected void processCommandLineArguments() {
	super.processCommandLineArguments();
    }

    /**
     * Completes I-TEST setup and initialization.
     */
    public void startup() {
	super.startup();

	frame = new ItestFrame(this);
	frame.setup();

	addTests();
	frame.pack();
	frame.setVisible(true);
    }

    /**
     * Creates a standard logo panel for I-TEST.
     * Overridden in subclasses that have, say, a picture to use instead.
     *
     * <p>This method is in the agent class, rather than the frame class,
     * to make it easier to define applications that have a different
     * logo panel.
     */
    public JPanel makeLogoPanel() {
	return new LogoPanel(symbolName, /*"I-Test",*/
			     "I-X Test Agent",
			     Util.resourceImageIcon("ip2-itest-logo.gif"));
    }

    /**
     * Handles external input.
     */
    public void handleInput(IPC.InputMessage message) {
	frame.receivePanel.handleInput(message);
    }

    public void addTool(ix.iface.util.ToolController tc) {
	frame.addTool(tc);
    }

    /**
     * Adds any tests common to all versions of I-TEST.
     */
    protected void addTests() {
	frame.addTestResources(Parameters.getList("test-menu"));
    }

}
