/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 30 03:18:27 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.ispace;

import java.util.*;

import ix.util.*;

public class RelationshipGroup extends AbstractAgentGroup {

    AgentRelationship rel;

    public RelationshipGroup(AgentRelationship rel, ContactManager cm) {
	super(rel.toString() + "s", 	// make plural
	      cm);
	this.rel = rel;
    }

    /**
     * Returns the collection of AgentData objects from which this
     * group's members are selected.
     *
     * @see AgentData
     * @see ContactManager#getAgentData(AgentRelationship)
     */
    public Collection getBasePopulation() {
	return Collect.ensureList(contactManager.getAgentData(rel));
    }

}
