/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Sep 30 17:37:31 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.ispace;

import java.util.*;
import ix.util.*;

/**
 * Standard relationships between agents.
 */
public final class AgentRelationship extends EnumeratedValue {

    private static List values = new LinkedList();

    private AgentRelationship() { }

    private AgentRelationship(String name) {
	this.name = name;
	recordValue(values, this);
    }	

    public static final AgentRelationship
	SUPERIOR     = new AgentRelationship("superior"),
	SUBORDINATE  = new AgentRelationship("subordinate"),
	PEER         = new AgentRelationship("peer"),
	CONTACT      = new AgentRelationship("contact"),
	SERVICE      = new AgentRelationship("service"),
	NONE         = new AgentRelationship("none");

    public String toString() {
	return name;
    }

    public static List values() {
	return Collections.unmodifiableList(values);
    }

    public static AgentRelationship valueOf(String name) {
	return (AgentRelationship)getValueElseError(values, name);
    }

}


