/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar 16 13:54:07 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2006, AIAI, University of Edinburgh
 */

package ix.ispace;
import java.util.*;
import ix.util.*;

/**
 * What we know about another agent.
 */
public class AgentData {

    protected String name;
    protected AgentRelationship relationship;
    protected ListOfCapability capabilities = // Set? /\/
	new LinkedListOfCapability();

    public AgentData() {
    }

    public AgentData(String name, AgentRelationship relationship) {
	this.name = name;
	this.relationship = relationship;
    }

    public AgentData(AgentData oldData) {
	this.name = oldData.name;
	this.relationship = oldData.relationship;
	this.capabilities = new LinkedListOfCapability(oldData.capabilities);
    }

    public String getName() { return name; }
    public void setName(String name) { this.name = name; }

    // /\/: Make names consistent
    // /\/: Maybe rename AgentRelationship to AgentRelation.
    public AgentRelationship getRelationship() {
	return relationship;
    }
    public void setRelationship(AgentRelationship relationship) {
	this.relationship = relationship;
    }

    public ListOfCapability getCapabilities() {
	return capabilities;
    }

    public void setCapabilities(ListOfCapability capabilities) {
	this.capabilities = capabilities;
    }

    public void setCapabilities(Collection capabilities) {
	setCapabilities(new LinkedListOfCapability(capabilities));
    }

    public void addCapability(Capability c) {
	Debug.noteln("Agent " + name + " gets " + c);
	capabilities.add(c);
    }

    public boolean hasCapability(Capability c) {
	// N.B. Here empty and null are treated the same, but null
	// really means unknown.
	// /\/: At present, null doesn't ever actually occur.
	for (Iterator i = capabilities.iterator(); i.hasNext();) {
	    Capability has = (Capability)i.next();
	    if (has.subsumes(c))
		return true;
	}
	return false;
    }

    public boolean hasCapability(Capability c, boolean defaultIfUnknown) {
	return capabilitiesAreUnknown()
	    ? defaultIfUnknown
	    : hasCapability(c);
    }

    public boolean capabilitiesAreUnknown() {
	return capabilities.isEmpty(); // s.b. == null /\/
    }

    public String toString() {
	return "AgentData[" + name + ", " + relationship + ", " +
	                  capabilities + "]";
    }

}
