/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Feb 18 02:52:08 2006 by Jeff Dalton
 * Copyright: (c) 2005, 2006, AIAI, University of Edinburgh
 */

package ix.iscript;

import java.io.Serializable;
import java.util.*;

import ix.util.lisp.Interpreter;
import ix.util.*;

/**
 * An object that can be used to wrap an I-Script {@link Expression}.
 * It carries the knowledge of how to translate the Expression into
 * the tree form used by {@link Interpreter}s.
 */
public class IScriptXmlSource implements IScriptSource, Serializable {

    protected static IScriptParser parser = new IScriptParser();

    protected Expression expression;

    public IScriptXmlSource() {
    }

    public Expression getExpression() {
	return expression;
    }

    public void setExpression(Expression expr) {
	this.expression = expr;
    }

    public String getSyntax() {
	return "iscript/xml";
    }

    public Interpreter.Expr parseSource() {
	return parser.parseExpression(expression);
    }

}
