/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Nov 22 17:26:34 2007 by Jeff Dalton
 * Copyright: (c) 2005, 2006, 2007, AIAI, University of Edinburgh
 */

package ix.iscript;

import ix.test.xml.LispSourceText;

/**
 * An object that can be used to wrap an I-Script {@link Expression}
 * that is written in a Lisp-like syntax.  It carries the knowledge
 * of how to translate the expression into the tree form used by
 * {@link ix.util.lisp.Interpreter Interpreter}s.
 *
 * <p>This allows source code to be written in XML using the ordinary
 * textual syntax.  For example:
 * <pre>
 *   &lt;i-script-lisp-source&gt;
 *     (defun f (x) (* x x))
 *     (defun g (x y) (/ (+ x y) 2))
 *   &lt;/i-script-lisp-source&gt;
 * </pre>
 */
public class IScriptLispSource extends LispSourceText {

    public IScriptLispSource(String text) {
	super(text);
    }

}
