/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Feb 18 03:28:03 2006 by Jeff Dalton
 * Copyright: (c) 2005, 2006, AIAI, University of Edinburgh
 */

package ix.iscript;

import java.net.URL;
import java.io.*;
import java.util.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.XML;

/**
 * An interpreter for the I-Script language.
 */
public class IScriptInterpreter {

    IScriptParser parser = new IScriptParser();

    IScriptLispInterpreter lisp = new IScriptLispInterpreter();

    public IScriptInterpreter() {
    }

    public static void main(String[] argv) {

	Parameters.processCommandLineArguments(argv);

	IScriptInterpreter iscript = new IScriptInterpreter();

	for (;;) {
	    System.out.println("I-Script:");
	    try {
		String input = Util.readLines();
		if (input.startsWith("<")) {
		    // XML Syntax.
		    Object obj = XML.objectFromXML(input);
		    Expression e = 
			(Expression)Util.mustBe(Expression.class, obj);
		    Object result = iscript.topLevelEval(e);
		    System.out.println(result);
		}
		else {
		    // Try Lisp Syntax.
		    Object obj = Lisp.readFromString(input);
		    Expression e = iscript.lisp.parseForm(obj).externalForm();
		    
		    Object result = iscript.topLevelEval(e);
		    System.out.println("In XML syntax:");
		    // System.out.println(XML.objectToXMLString(e));
		    System.out.println(e.toString());
		    System.out.println("Result:");
		    System.out.println(result);
		    System.out.println("");
		}
	    }
	    catch (Throwable t) {
		Debug.noteException(t);
	    }
	}
    }

    public Object topLevelEval(Expression e) {
	return lisp.topLevelEval(parser.parseExpression(e));
    }

    class IScriptLispInterpreter extends LispInterpreter {

	IScriptLispInterpreter() {
	    super();
	}

	protected void defineSyntax() {
	    // /\/: We should have no Lisp syntax, but we need it
	    // because the LispInterpreter uses it when defining
	    // some builtins.  /\/: Actually, we also use the
	    // Lisp interpreter to parse expressions typed in
	    // Lisp syntax.
	    super.defineSyntax();
	}

    }

}
