/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Sep 19 18:16:02 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.ip2.*;
import ix.icore.*;
import ix.icore.plan.Plan;
import ix.icore.process.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

/**
 * Simple, non-backtracking, pure HTN planning algorithm.
 *
 * <p>"There is no alternative."</p>
 */
public class Thatcher extends PlannerBase {

    public Thatcher(boolean standAlone) {
	super(standAlone);	// true means make this "the" agent
    }

    /**
     * Standalone main program.  One plan in, one plan out.
     * To specify the initial plan, use the <tt>plan</tt>
     * command-line argument.  The result will be written to
     * the file specified by the <tt>output</tt> argument.
     * If no output is specified, the user is asked by a dialog.
     */
    public static void main(String[] argv) {
	Thatcher t = new Thatcher(true);
	t.mainStartup(argv);
	t.plan();
	t.outputPlan();
	t.exit();
    }

    /**
     * Install any built-in issue and activity handlers.
     */ 
    protected void addHandlers() {
	controller
	    .addActivityHandler(new ThatcherActivityHandler(this));
    }

    /*
     * Finally, the actual planner
     */

    public void plan() {
	Agenda agenda = controller.getActivityAgenda();
	while (true) {
	    ActivityItem at = findExecutable();
	    if (at == null)
		break;
	    HandlerAction act = (HandlerAction)at.getActions().get(0);
	    agenda.handleItem(at, act);
	}
	if (!planIsComplete())
	    throw new RuntimeException("Cannot complete plan");
    }

    ActivityItem findExecutable() {
	for (Iterator i = allActivities().iterator(); i.hasNext();) {
	    ActivityItem a = (ActivityItem)i.next();
	    if (a.getStatus() == Status.POSSIBLE)
		return a;
	}
	return null;
    }

    List allActivities() {
	return controller.getActivityAgenda().getItems();
    }

    boolean planIsComplete() {
	return PNode.allHaveStatus(allActivities(), Status.COMPLETE);
    }

}
