/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Jun  4 17:10:58 2008 by Jeff Dalton
 * Copyright: (c) 2004, 2005, 2008, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.ip2.*;
import ix.icore.*;
import ix.icore.process.*;
import ix.icore.domain.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

/**
 * A way to achieve a condition by using a refinement for an introduced node.
 * Each goal-node has a list of achievers, one for each refinement that
 * might be used to satisfy the condition that goal-node was introduced
 * to satisfy.
 */
class SlipAchiever {

    PatternAssignment cond;
    Refinement refinement;
    PatternAssignment effect;
    MatchEnv condMatchEnv;

    SlipAchiever(PatternAssignment cond,
		 Refinement refinement,
		 PatternAssignment effect,
		 MatchEnv condMatchEnv) {
	this.cond = cond;
	this.refinement = refinement;
	this.effect = effect;
	this.condMatchEnv = condMatchEnv;
	Debug.noteln("Making achiever for " + cond +
		     " using " + refinement + " " + effect +
		     " with env " + condMatchEnv);
    }

    MatchEnv rematchCond() {
	// Some Variables may have been bound since we originally
	// did the matching.
	MatchEnv pEnv = Matcher.match(cond.getPattern(), effect.getPattern());
	if (pEnv == null)
	    return null;
	else
	    return Matcher.match(cond.getValue(), effect.getValue(), pEnv);
    }

    public String toString() {
	return "SlipAchiever[using " + refinement + " for cond " + cond + "]";
    }

}
