/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 22 21:24:19 2006 by Jeff Dalton
 * Copyright: (c) 2001 - 2006, AIAI, University of Edinburgh
 */

package ix.ip2.test;

import java.util.*;

import ix.ip2.PanelFrame;

/**
 * An object that becomes a submenu in the test menu.
 */
public class TestSubmenu implements TestElement {

    protected String menuText;
    protected List testItems;

    public TestSubmenu() { }

    public String getMenuText() {
	return menuText;
    }

    public void setMenuText(String menuText) {
	this.menuText = menuText;
    }

    public List getTestItems() {
        return testItems;
    }

    public void setTestItems(List testItems) {
        this.testItems = testItems;
    }

    /**
     * Tells the panel to add a submenu to the test menu.
     */
    public void addToMenu(PanelFrame frame) {
	frame.addTestSubmenu(menuText, testItems);
    }

}
