/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Nov  9 00:20:40 2004 by Jeff Dalton
 * Copyright: (c) 2001 - 2002, AIAI, University of Edinburgh
 */

package ix.ip2.test;

import java.util.*;

import ix.icore.*;
import ix.util.*;
import ix.util.xml.XML;

/**
 * A test that sends a single message.  A TestItem is also used as an
 * element of a TestSequence, in which case the menuText is ignored
 * and may be null.
 *
 * @see TestSequence
 */
public class TestItem extends PanelTest {

    protected int delayBefore = 0;
    protected String toName = "me";
    protected Sendable contents;

    public TestItem() { }

    public TestItem(String menuText, Sendable contents) {
	this.menuText = menuText;
	this.contents = contents;
    }

    public TestItem(TaskItem contents) {
	this.contents = contents;
	this.menuText = defaultMenuText();
    }

    protected String defaultMenuText() {
	String type = XML.nameForClass(contents.getClass());
	if (contents instanceof TaskItem) {
	    TaskItem item = (TaskItem)contents;
	    String pat = PatternParser.unparse(item.getPattern());
	    return "Add " + type + " " + pat;
	}
	else
	    return "Add " + contents;
    }

    public int getDelayBefore() { return delayBefore; }

    public void setDelayBefore(int delayBefore) {
	this.delayBefore = delayBefore;
    }

    public String getToName() { return toName; }

    public void setToName(String toName) {
	this.toName = toName;
    }

    public Sendable getContents() { return contents; }

    public void setContents(Sendable contents) {
	this.contents = contents;
    }

    /**
     * Returns the value of getMenuText() with any occurrences of
     * <code>"$to"</code> replaced by the value of getToName().
     */
    public String getFullMenuText() {
	String text = getMenuText();
	if (text == null)
	    text = defaultMenuText();
	return Strings.replace("$to", getToName(), text);
    }

    public List getTestItems() {
	return Collections.singletonList(this);
    }

}
