/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 16 01:31:36 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.ip2.event;

import java.util.EventListener;

import ix.ip2.HandlerAction;
import ix.icore.Report;

public interface AgendaItemListener extends EventListener {

    public void statusChanged(AgendaItemEvent e);

    public void priorityChanged(AgendaItemEvent e);

    public void handlerActionsChanged(AgendaItemEvent e);

    public void newHandlerAction(AgendaItemEvent e, HandlerAction a);

    public void newReport(AgendaItemEvent e, Report report);

    public void agendaItemEdited(AgendaItemEvent e);
    // covers any other changes

}

// Issues:
// * It looks like the JDK way to handle something like newOption
//   would be to define IssueOptionEvent as a subclass of IssueEvent
//   and include the option in the IssueOptionEvent rather than
//   passing it as a second parameter.
// * Should there be both handlerActionsChanged and newHandlerAction?
//   How about having a handlerActionsRemoved(AgendaItemEvent, Collection)?
