/* Author: Jeff Dalton
 * Updated: Fri May 16 15:05:51 2003 by Jeff Dalton
 * Copyright: (c) 2001 - 2002, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.awt.Component;

import ix.icore.process.event.ProcessStatusListener;

// Must also be an instance of a subclass of java.awt.Component
// so that it can be added to a JPanel.  /\/

public interface StateViewer extends ProcessStatusListener {

    /**
     * Return the GUI component that should be placed in the agent's
     * main user-interface frame.  The frame is passed as a parameter
     * in case different objects must be returned for different frame
     * classes.
     */
    public Component getView(PanelFrame frame);

    /**
     * Sets the viewer back to its initial state (or a reasonable
     * approximation).
     */
    public void reset();

}

