/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Nov 12 17:14:21 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.util.*;

/**
 * A simple explanation of why a {@link HandlerAction} is not ready
 * to be used.  This class should be used when there is only a textual
 * explanation, without any inspectable objects that are relevant to
 * the explanation.
 *
 * @see HandlerAction#isReady()
 * @see HandlerAction#getUnreadyReason()
 */
public class SimpleUnreadyReason extends ActionUnreadyReason {

    protected String[] explanation;

    /**
     * Creates a simple unready reason with a one-line explanation.
     */
    public SimpleUnreadyReason(HandlerAction action, String explanation) {
	this(action, new String[] { explanation });
    }

    /**
     * Creates a simple unready reason with a possibly multi-line explanation.
     */
    public SimpleUnreadyReason(HandlerAction action, String[] explanation) {
	super(action);
	this.explanation = explanation;
    }

    public String[] getExplanation() {
	return explanation;
    }

}
