/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Nov 15 17:41:57 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.ip2;

/**
 * Generates HandlerActions that let a user do nothing or
 * make an {@link AgendaItem} complete.  This handler is
 * not normally used in I-P2.  A {@link CompletionHandler}
 * is used instead.
 */
public class SimpleCompletionHandler extends ItemHandler {

    public SimpleCompletionHandler() {
	super("Mark as complete");
    }

    public void addHandlerActions(AgendaItem item) {
	// Standard options that all items have.
	// The ActivityAgenda.OtherReportsActivity wantsActionsFrom
	// method must allow actions from this class.  /\/
	item.addAction(new HandlerAction.NoAction());
	item.addAction(new HandlerAction.Manual());
	item.addAction(new HandlerAction.NotApplicable());
    }

}
