/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jan 16 03:01:11 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2003, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.util.*;

/**
 * Generates a {@link HandlerAction} that removes an issue and adds
 * a corresponding activity.  Compare {@link TransformToActivityHandler}.
 */
public class PerformAsActivityHandler extends IssueHandler {

    Ip2 ip2;

    public PerformAsActivityHandler(Ip2 ip2) {
	super("Perform as activity");
	this.ip2 = ip2;
    }
	
    public void handle(AgendaItem item) {
	Issue issue = (Issue)item.getAbout();
	Activity activity = new Activity(issue.getPattern());
	// Take across some other fields ...
	activity.setSenderId(issue.getSenderId());
	activity.setPriority(issue.getPriority());
	activity.setReportBack(issue.getReportBack());
	activity.setRef(issue.getRef());
	// ... Any others ...?  /\/
	// Remove the issue item
	ip2.getController().getIssueAgenda().removeItem(item);
	// Add the activity
	ip2.getController().addActivity(activity);
    }

}

// Issues:
// * Need a better approach than passing ip2 as a parameter to the
//   constructor and directly referring to ip2.controller.
