/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Sep  4 23:10:40 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2004 - 2006, AIAI, University of Edinburgh
 */

package ix.ip2;

import javax.swing.*;

import java.awt.Component;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Dimension;

import java.awt.event.*;

import ix.iview.*;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.util.LogoPanel;
import ix.iface.util.IconImage;
import ix.iplan.OptionUI;
import ix.util.*;

/**
 * A revised version of the main frame of the I-P2 user interface.
 */
public class NewIp2Frame extends Ip2Frame implements ActionListener {

    public JLabel optionLabel = new JLabel("Option Name", JLabel.CENTER);
    OptionUI optionUI;

    public NewIp2Frame(Ip2 ip2) {
	super(ip2);
	optionUI = new OptionUI(ip2.getOptionManager(), this);
    }

    protected void setUp() {
	setIconImage(IconImage.getIconImage(this));
	activityViewer = ip2.activityViewer;
	issueViewer = ip2.issueViewer;
	stateViewer = ip2.stateViewer;
	annotationViewer = ip2.annotationViewer;

	contentPane = getContentPane();

	setSize(500, 400);	// preliminary
	setJMenuBar(makeMenuBar());
	// Layout manager defaults to BorderLayout.
	// contentPane.setLayout(new FlowLayout()); // probably not too clever

	// Package issue viewer
	ThingEditorPanel issuePanel = 
	  new ThingEditorPanel(null, true, "Issues", (JComponent)issueViewer);

	// Package activity viewer
	ThingEditorPanel activityPanel = 
	  new ThingEditorPanel(null, true, "Activities", 
			       (JComponent)activityViewer);

	// Package state viewer
 	ThingEditorPanel statePanel =
 	    new ThingEditorPanel(null, true, "State",
				 (JComponent)stateViewer.getView(this));

	// Package annotation viewer
	ThingEditorPanel annotationsPanel =
	    new ThingEditorPanel(null, true, "Annotations",
				 (JComponent)annotationViewer.getView(this));

	// Put the viewers in nested split panes.

	// JSplitPane split1 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
	// JSplitPane split2 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
	split1.setTopComponent(issuePanel);
	split1.setBottomComponent(split2);

	split2.setTopComponent(activityPanel);
	split2.setBottomComponent(split3);

	split3.setTopComponent(statePanel);
	split3.setBottomComponent(annotationsPanel);

        split1.setOneTouchExpandable(true);
        split2.setOneTouchExpandable(true);
        split3.setOneTouchExpandable(true);

    	split1.setResizeWeight(0.25);
   	split2.setResizeWeight(0.33);
    	split3.setResizeWeight(0.50);

	contentPane.add(split1);

	// Add something that identifies the system etc.
	logoPanel = ip2.makeLogoPanel();
	contentPane.add(logoPanel, BorderLayout.SOUTH);

	if (ip2.showOptions) {
	    // Put the option label centered at the top.
	    contentPane.add(optionLabel, BorderLayout.NORTH);
	}

    }

    protected JMenuBar makeMenuBar() {
        JMenuBar bar = super.makeMenuBar();
	if (ip2.showOptions)
	    bar.add(optionUI.getOptionMenu(), 3);
        return bar;
    }

  /*
    JPanel wrap(Component c) {
	JPanel p = new JPanel();
	p.setLayout(new BorderLayout());
	p.add(c);
	return p;
    }
  */

    JSplitPane split3 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);

    protected void becomeVisible() { // sep method so can do it last
	// It is expected that this is called only once.

	if (Parameters.haveParameter("frame-size")) {
	    Dimension size = Parameters.getDimension("frame-size");
	    pack();		// needed for divider adjust /\/
	    setSize(size);
	}
	else
	    setReasonableSize();

	// Seem to need this here, rather than, say, later.
	super.validate();

	// Adjust the split pane dividers.
    	split1.setDividerLocation(0.25);
    	split2.setDividerLocation(0.40);
    	split3.setDividerLocation(0.80); // makes no sense but works /\/

	// Make it visible
	setVisible(true);

    }

}
