/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug 25 15:38:06 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.icore.plan.Plan;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.XML;

/**
 * Generates a {@link HandlerAction} that loads a plan that contains
 * world-state.
 */
public class LoadStateHandler extends LoadPlanHandler {

    public static final Symbol S_LOAD_STATE = Symbol.intern("load-state");

    LoadStateHandler(Ip2 ip2) {
	super(ip2, "load-state");
    }

    public void addHandlerActions(AgendaItem item) {
	item.addAction(new LoadPlanAction(item, "Load state"));
    }

}
