/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue May  6 16:12:00 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.ispace.*;

import ix.util.*;

/**
 * Generates HandlerActions for an AgendItem.
 */
public class InvokeHandler extends ForwardingHandler {

    public InvokeHandler(IXAgent agent) {
	super(agent,
	      "Invoke",				// action description
	      AgentRelationship.SERVICE, 	// required relationship
	      true);				// reportBack
	this.capabilityDefault = false;		// strict
    }

    public ForwardingAction makeForwardingAction
                                (String toName, AgendaItem about) {
	return new InvokeAction(toName, about);
    }

    class InvokeAction extends ForwardingAction {
	InvokeAction(String toName, AgendaItem about) {
	    super(toName, about);
	    this.shortDescription = "Invoke " + toName;
	}
    }

}

