/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jun  9 01:11:09 2008 by Jeff Dalton
 * Copyright: (c) 2007, 2008, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.icore.process.*;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;

import ix.iplan.DomainAnalyser;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.util.context.*;

/**
 * Manager for for-all constraints.
 *
 * <p>The syntax is:
 * <pre>
 *    (FOR ALL (variable IN list : pattern) = value)
 * </pre></p>
 */
public class ForAllCM implements ConstraintManager, IXAgentExtension {

    private static final Symbol
	FOR   = Symbol.intern("for"),
	ALL   = Symbol.intern("all"),
	IN    = Symbol.intern("in"),
	COLON = Symbol.intern(":");

    Ip2 ip2;			//\/ for IXAgentExtension
    Ip2ModelManager mm;

    public ForAllCM(Ip2 ip2) {
	this.ip2 = ip2;
	this.mm = ip2.getIp2ModelManager();
    }

    public void registerWith(ConstraintManagerRegistry r) {
	r.addConstraintManager(this, FOR, new Symbol[]{ALL});
    }

    public void installExtension() {
	mm.addConstraintManager(this);
    }

    public void reset() {
    }

    public void clear() {
    }

    /** @throws UnsupportedOperationException if called. */
    public void addConstraint(Constraint c) {
      throw new UnsupportedOperationException
	("Method addConstraint(Constraint) is not supported by this CM.");
    }

    public void addConstraint(PNode node, Constraint c) {
	Debug.noteln("ForAll CM adding", c);
	Debug.noteln("At", node);
	// evalConstraint(node, c);
    }

    public void evalAtBegin(PNodeEnd ne, Constraint c) {
	Debug.noteln("ForAll CM eval " + c + " at " + ne);
	Debug.expectSame(End.BEGIN, ne.getEnd());
	// outer pattern: (substVar IN list : pattern)
	LList outerPattern = c.getPattern();
	if (! (outerPattern.size() == 5 &&
	       outerPattern.get(0) instanceof Symbol &&
	       outerPattern.get(1) == IN &&
	       outerPattern.get(2) instanceof List &&
	       outerPattern.get(3) == COLON &&
	       outerPattern.get(4) instanceof LList))
	    throw new IllegalArgumentException();
	Symbol substVar = (Symbol)outerPattern.get(0);
	List   list     =   (List)outerPattern.get(2);
	LList  pattern  =  (LList)outerPattern.get(4);
				
	Object value = c.getValue();

	
// 	c = (Constraint)Variable.removeAllVars(c);
// 	LList pattern = c.getPattern();
// 	PNode user = (PNode)useTable.get(pattern);
// 	if (user != null)
// 	    throw new FailureException
// 		(pattern + " already in use at " + user);
// 	// Cool.  So we can use it.
// 	useTable.put(pattern, ne.getNode());
// 	// If someone was using it before, we must be linked after them.
// 	PNode releaser = (PNode)freeTable.get(pattern);
// 	if (releaser != null)
// 	    mm.linkBefore(releaser.getEnd(), ne);
    }

    public void evalAtEnd(PNodeEnd ne, Constraint c) {
	Debug.noteln("ForAll CM eval " + c + " at " + ne);
	Debug.expectSame(End.END, ne.getEnd());
    }

    public boolean mightInteract(PNodeEnd ne1, Constraint c1,
				 PNodeEnd ne2, Constraint c2) {
	// return DomainAnalyser.match(c1.getPattern(), c2.getPattern());
	return true;
    }

}
