/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jun  9 01:01:28 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.icore.process.*;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;

import ix.iplan.DomainAnalyser;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.util.context.*;

/**
 * Manager for "consume-the-only" constraints.
 */
public class ConsumeTheOnlyCM implements ConstraintManager {

    private static final Symbol	CONSUME_THE_ONLY =
	Symbol.intern("consume-the-only");

    // Maps a resource pattern to the PNode, if any, that used it.
    ContextHashMap useTable = new ContextHashMap();

    public ConsumeTheOnlyCM() {
    }

    public void registerWith(ConstraintManagerRegistry r) {
	r.addConstraintManager
	    (this, Symbol.intern("resource"),
	           new Symbol[]{CONSUME_THE_ONLY});
    }

    public void reset() {
	useTable.clearCompletely();
    }

    public void clear() {
	useTable.clear();
    }

    /** @throws UnsupportedOperationException if called. */
    public void addConstraint(Constraint c) {
      throw new UnsupportedOperationException
	("Method addConstraint(Constraint) is not supported by this CM.");
    }

    public void addConstraint(PNode node, Constraint c) {
	Debug.noteln("CTO CM adding", c);
	Debug.noteln("At", node);
    }

    public void evalAtBegin(PNodeEnd ne, Constraint c) {
	Debug.noteln("CTO CM eval " + c + " at " + ne);
	Debug.expectSame(End.BEGIN, ne.getEnd());
	c = (Constraint)Variable.removeAllVars(c);
	LList pattern = c.getPattern();
	// See if the pattern's already been consumed.
	PNode user = (PNode)useTable.get(pattern);
	if (user != null)
	    // Yes.
	    throw new FailureException
		(pattern + " already consuimed at " + user);
	// No.  Cool.  So we can use it.
	useTable.put(pattern, ne.getNode());
    }

    public void evalAtEnd(PNodeEnd ne, Constraint c) {
	Debug.noteln("CTO CM eval " + c + " at " + ne);
	Debug.expectSame(End.END, ne.getEnd());
    }

    public boolean mightInteract(PNodeEnd ne1, Constraint c1,
				 PNodeEnd ne2, Constraint c2) {
	return DomainAnalyser.match(c1.getPattern(), c2.getPattern());
    }

}
