/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jan 16 01:47:33 2004 by Jeff Dalton
 * Copyright: (c) 2003 - 2004, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.ispace.*;
import ix.util.lisp.*;

public class ConnectHandler extends ActivityHandler {

    IXAgent agent;

    Symbol S_CONNECT = Symbol.intern("connect");

    public ConnectHandler(IXAgent agent) {
	super("Connect agent");
	this.agent = agent;
    }

    public List getSyntaxList() {
	return (LList)Lisp.readFromString
	    ("((connect ?agent-name ?relationship))");
    }
	
    public boolean appliesTo(AgendaItem item) {
	LList pattern = item.getPattern();
	return pattern.length() == 3
	    && pattern.get(0) == S_CONNECT;
    }
	
    public void addHandlerActions(AgendaItem item) {
	item.addAction
	    (new HandlerAction.AutomaticWhenBound(item, this));
    }
	
    public void handle(AgendaItem item) {
	// (connect ?agentName ?Relationship)
	LList pattern = (LList)Variable.removeVars(item.getPattern());
	String name = pattern.get(1).toString();
	String relName = pattern.get(2).toString();
	AgentRelationship rel = AgentRelationship.valueOf(relName);
	ContactManager contactManager = agent.getContactManager();
	AgentData data = contactManager.getAgentData(name);
	if (data == null)
	    contactManager.addAgent(name, rel);
	else if (data.getRelationship() != rel)
	    contactManager.changeRelationship(name, rel);
	item.setStatus(Status.COMPLETE);	    			  
    }

}
