/* Author: Jeff Dalton
 * Updated: Sun Jun  1 21:54:45 2003 by Jeff Dalton
 * Copyright: (c) 2001 - 2003, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.awt.Component;

import javax.swing.*;

import java.awt.BorderLayout;
import java.awt.event.*;

import java.util.*;

import ix.icore.process.event.*;
import ix.icore.event.*;
import ix.iface.util.KeyValueTable;
import ix.util.*;

public class AnnotationViewTable extends JPanel implements AnnotationViewer {

    protected Ip2 ip2;
    protected ViewTable viewTable;

    /**
     * Constructs a viewer for the indicated agent.
     */
    public AnnotationViewTable(Ip2 ip2) {
	super();
	this.ip2 = ip2;
	this.viewTable = new ViewTable();

	setLayout(new BorderLayout());
	JTable tab = viewTable.getJTable();
	add(tab.getTableHeader(), BorderLayout.NORTH);
	add(tab, BorderLayout.CENTER);

    }

    public Component getView(PanelFrame frame) {
	return viewTable.getJTable();
    }

    /**
     * Sets the viewer back to something approximating its initial state.
     */
    public void reset() {
	viewTable.reset();
    }

    public void getNewItemFromUser() {
	editAnnotation("sample key", "sample value");
    }

    public void setAnnotation(AnnotationEvent event) {
	Debug.noteln("Event", event);
	if (event.isDeletion())
	    viewTable.deleteEntry(event.getKey());
	else
	    viewTable.recordNewValue(event.getKey(), event.getValue());
    }

    class ViewTable extends KeyValueTable {

	ViewTable() {
	    super("Key", "Value");
	}

	protected RowPopupMenu makePopupMenu() {
	    return new AnnotationPopupMenu();
	}

	class AnnotationPopupMenu extends RowPopupMenu {
	    AnnotationPopupMenu() {
		super();
		add(makeMenuItem("Show Details"));
		add(makeMenuItem("Delete"));
	    }
	}

	protected void doPopupAction(ActionEvent event, int row, Object key) {
	    String command = event.getActionCommand();
	    if (command.equals("Show Details")) {
		    showDetails(key);
	    }
	    else if (command.equals("Delete")) {
		ip2.getModelManager().removeAnnotation(key);
	    }
	    else
		throw new ConsistencyException
		    ("Nothing to do for " + command);
	}

    }

    /*
     * "Details" view
     */

    protected AnnotationEditor annotationEditor;

    protected void showDetails(Object key) {
	Object value = viewTable.getValue(key);
	editAnnotation(key, value);
    }

    protected void editAnnotation(Object key, Object value) {
	if (annotationEditor == null) {
	    annotationEditor = new AnnotationEditor(ip2);
	}
	annotationEditor.editAnnotation(key, value);
	annotationEditor.setVisible(true);
    }

}

// Issues:
// * editAnnotation(...) or ensureAnnotationEditor(...)?
