/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jun 19 19:22:36 2008 by Jeff Dalton
 * Copyright: (c) 2001 - 2007, AIAI, University of Edinburgh
 */

package ix.ip2;

import ix.icore.*;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;

import ix.util.*;
import ix.util.lisp.*;

/**
 * An AgendaEntry to represents an activity.
 */
public class ActivityItem extends AgendaItem {

    public static Symbol EXPANSION_REFINEMENT_NAME =
	Symbol.intern("expansion-refinement-name");

    public ActivityItem(Activity activity) {
	super(activity);
    }

    public ActivityItem(ActivityItem parent, Activity activity) {
	super(parent, activity);
    }

    @Override
    protected PNode makePNode(PNode parent, LList pattern) {
	return new ActivityItem((ActivityItem)parent, new Activity(pattern));
    }

    @Override
    public void setRefinement(Refinement r) {
	super.setRefinement(r);
	recordExpansionRefinementName(); //\/ Not context-layered :(
    }

    public void recordExpansionRefinementName() {
	Refinement r = getRefinement();
	// Debug.expect(r != null, "Missing expansion refinement for", this);
	if (r != null && r.getName() != null) {
	    Ip2ModelManager mm = (Ip2ModelManager)getModelManager();
	    if (mm != null)
		mm.saveUndoAction(new UndoSetRefinement());
	    recordExpansionRefinementName(getAbout(), r);
	}
    }

    private void recordExpansionRefinementName(TaskItem about, Refinement r) {
	if (r.getName() != null) {
	    about.setAnnotation(EXPANSION_REFINEMENT_NAME, r.getName());
	}
    }

    public String getExpansionRefinementName() {
	return (String)getAbout().getAnnotation(EXPANSION_REFINEMENT_NAME);
    }

    private class UndoSetRefinement extends AbstractUndoAction {
	private UndoSetRefinement() {
	    super("set expansion refinement name");
	}
	public void undo() {
	    if (getExpansionRefinementName() != null)
		getAbout().removeAnnotation(EXPANSION_REFINEMENT_NAME);
	}
    }

}
