/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Aug 21 15:56:11 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.iface.util;

import java.util.*;
import javax.swing.*;

import ix.icore.IXAgent;
import ix.icore.event.AgentNameEvent;
import ix.icore.event.AgentNameListener;

import ix.util.*;

/**
 * The main frame of an I-X tool.
 */
public class ToolFrame extends JFrame implements AgentNameListener {

    protected static WeakHashMap toolFrames = new WeakHashMap();

    public ToolFrame() {
	super();
	toolFrames.put(this, null);
    }

    public ToolFrame(String title) {
	super(title);
	toolFrames.put(this, null);
    }

    {
	if (IXAgent.getAgent() != null)
	    IXAgent.getAgent().addAgentNameListener(this); // /\/ questionable
    }

    public void setVisible(boolean v) {
	if (v) setState(NORMAL);		// ensure not iconified
	super.setVisible(v);
    }

    /*
    public void dispose() {
	Debug.noteln("Something's trying to close " + this + getTitle());
	Debug.noteException(new RuntimeException("Just for a backtrace"));
    }
    */

    public void symbolNameChanged(AgentNameEvent e) {
	String title = getTitle();
	if (title.startsWith(e.getOldName()))
	    setTitle(e.getNewName() 
		     + title.substring(e.getOldName().length()));
    }

    public static void walkToolFrames(Proc p) {
	for (Iterator i = toolFrames.keySet().iterator(); i.hasNext();) {
	    p.call(i.next());
	}
    }

}
