/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Apr 27 03:53:28 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.iface.util;

import java.awt.Container;
import java.awt.event.*;

import javax.swing.*;
import java.util.*;

import ix.util.*;

/**
 * A basic utility frame for use in I-X agents.
 */
public abstract class SimpleToolFrame extends ToolFrame {

    protected CatchingActionListener safetyListener =
	new CatchingActionListener();

    protected Container contentPane;

    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu("File");

    public SimpleToolFrame() {
	super();
    }

    public SimpleToolFrame(String title) {
	super(title);
    }

    public void setActionListener(ActionListener listener) {
	safetyListener.setInnerListener(listener);
    }

    protected void setup() {
	contentPane = getContentPane();
    }

    protected void addDefaultMenuBar() {
	setJMenuBar(menuBar);
	menuBar.add(fileMenu);
	fileMenu.add(makeMenuItem("Close"));
    }

    protected JMenuItem makeMenuItem(String text) {
	JMenuItem item = new JMenuItem(text);
	item.addActionListener(safetyListener);
	return item;
    }

    protected JButton makeButton(String command) {
	JButton b = new JButton(command);
	b.addActionListener(safetyListener);
	return b;
    }

    protected JPanel makeButtonPanel(String[] buttons) {
	JPanel panel = new JPanel();
	// Stick with default flowlayout for now.
	for (int i = 0; i < buttons.length; i++) {
	    String actionCommand = buttons[i];
	    panel.add(makeButton(actionCommand));
	}
	return panel;
    }

}
