/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Aug 29 23:15:30 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.iface.util;

import java.awt.Frame;
import java.awt.Image;
import javax.swing.ImageIcon;

import java.util.*;

import ix.util.*;

import ix.ip2.Ip2Frame;
import ix.iview.SimpleDomainEditor;
import ix.ip2.ItemEditor;
import ix.ichat.ChatFrame;
import ix.ispace.ISpaceTool;

/**
 * Class used to set an appropriate icon image for a frame.
 * This image is used when the platform / window manager wants
 * an image to display when the frame is "minimized" / iconified.
 *
 * <p>The image is selected based on the frame class, as determined
 * by which of the setIconImage methods is called.  The code that
 * initializes the frame sould contain a line that looks something
 * like this:
 * <pre>
 *     frame.setIconImage(IconImage.getIconImage(frame));
 * </pre>
 *
 * <p>In some cases, the declared frame class may not be distinctive,
 * and then some other object should be used.  Of course, there needs
 * to be a corresponding method in this class.
 *
 * <p>In effect, this class is not a general utility - just a way
 * to put all of the IconImage information in one place.
 */
public class IconImage {

    private static Map imageCache = new HashMap();

    private IconImage() { }		// block instantiation

    public static Image getIconImage(Frame frame) {
	return getIconImage("ip2-icon.gif");
    }

    public static Image getIconImage(SimpleDomainEditor ed) {
	return getIconImage("ip2-edit-icon.gif");
    }

    public static Image getIconImage(ItemEditor ed) {
	return getIconImage("ip2-details-icon.gif");
    }

    public static Image getIconImage(ChatFrame frame) {
	return getIconImage("ip2-message-icon.gif");
    }

    public static Image getIconImage(ISpaceTool ist) {
	return getIconImage("ip2-space-icon.gif");
    }

    public static Image getIconImage(String filename) {
	Image image = (Image)imageCache.get(filename);
	if (image == null) {
	    image = Util.resourceImageIcon(filename).getImage();
	    imageCache.put(filename, image);
	}
	return image;
    }

}
