/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Dec  6 04:24:16 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.*;

import javax.swing.text.StyleConstants;
import javax.swing.text.Document;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
// import javax.swing.text.AttributeSet;
import javax.swing.text.Segment;

import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import java.io.OutputStream;

import java.util.*;

import ix.util.*;

/**
 * A debugging utility that outputs a description of an HTMLDocument.
 */
public class HtmlDescriber {

    protected HtmlWriter out;

    public HtmlDescriber(HtmlWriter out) {
	this.out = out;
    }

    public HtmlDescriber(OutputStream out) {
	this(new HtmlWriter(out));
    }

    public void describe(HTMLDocument doc) {
	Element root = doc.getDefaultRootElement();
	describe(root);
	flush();
    }

    public void flush() {
	out.flush();
    }

    public void describe(Element elt) {
	String name = elt.getAttributes()
	                  .getAttribute(StyleConstants.NameAttribute)
	                   .toString();
	out.indent(out.getTagDepth() * 2);
	out.tag(name);
	out.write("  " + elt.getStartOffset() + ".." + elt.getEndOffset());
	out.newLine();
	if (elt.isLeaf()) {
	    describeElementText(elt);
	}
	else {
	    // if (name.equals("td")) describeElementText(elt);
	    for (int i = 0; i < elt.getElementCount(); i++) {
		Element child = elt.getElement(i);
		describe(child);
	    }
	}
	out.indent((out.getTagDepth() - 1) * 2);
	out.end(name);
	out.newLine();
    }

    private Segment seg = new Segment(); // for grabbing text from the document

    private void describeElementText(Element elt) {
	Document doc = elt.getDocument();
	int start = elt.getStartOffset(), end = elt.getEndOffset();
	try {
	    doc.getText(start, end-start, seg);
	}
	catch (BadLocationException e) {
	    throw new RethrownException(e);
	}
	out.indent(out.getTagDepth() * 2 + 1);
	out.write(Strings.quote(seg.toString()));
	out.newLine();
    }

}
