/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Sep  6 20:16:12 2005 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iface.util;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import java.util.*;

import ix.util.*;

public class CheckTableDialog extends JDialog 
                              implements ActionListener {

    CheckTable table;

    public static Object[] showDialog(Component parent, 
				      String title,
				      Object[] data) {
	return showDialog(parent, title, data, null);
    }

    public static Object[] showDialog(Component parent, 
				      String title,
				      Object[] data,
				      Object[] selected) {
	Frame frame = JOptionPane.getFrameForComponent(parent);
	CheckTableDialog dialog =
	    new CheckTableDialog(frame, title, data, selected);
	dialog.show();
	return dialog.getSelectedValues();
    }

    public static void main(String[] argv) {
	while (true) {
	    Object[] selected = CheckTableDialog.showDialog
		(null, "Pick one", argv);
	    System.out.println("Selected: " + Arrays.asList(selected));
	}
    }

    /**
     * Creates a modal dialog with the specified owner frame,
     * title, and list data.
     */
    public CheckTableDialog(Frame owner, String title,
			    Object[] data, Object[] selected) {
	super(owner, title, true);
	JPanel contentPane = new JPanel();
	setContentPane(contentPane);
	contentPane.setLayout(new BorderLayout());
	contentPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	// The CheckTable
	table = new CheckTable(title, data, selected);
	JScrollPane tableScroll = new JScrollPane(table.getJTable());
	tableScroll.setBorder
	    (BorderFactory.createTitledBorder("Selection of " + title));
	contentPane.add(tableScroll, BorderLayout.CENTER);
	// The buttons
	JButton cancel = IFUtil.makeButton("Cancel", this);
	JButton ok = IFUtil.makeButton("OK", this);
	Box buttons = Box.createHorizontalBox();
	buttons.add(Box.createHorizontalGlue());
	buttons.add(ok);
	buttons.add(Box.createRigidArea(new Dimension(5, 0)));
	buttons.add(cancel);
	buttons.add(Box.createHorizontalGlue());
	contentPane.add(buttons, BorderLayout.SOUTH);
	pack();
	setLocationRelativeTo(owner);
    }

    public Object[] getSelectedValues() {
	return table.getSelectedValues();
    }

    public void actionPerformed(ActionEvent e) {
	String command = e.getActionCommand();
	Debug.noteln("ListSelectionDialog command", command);
	if (command.equals("OK")) {
	    dispose();
	}
	else if (command.equals("Cancel")) {
	    table.clearSelections();
	    dispose();
	}
	else
	    throw new ConsistencyException
		("Don't know what to do for", command);
    }

}
