/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 22 22:57:27 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.*;

import java.awt.Component;

import ix.util.*;

/**
 * A JMenu that can handle a long list of items by "chaining"
 * every so many items to a "More" submenu.
 *
 * <p>N.B. Only the {@link #add(JMenuItem)} and {@link #addSeparator()}
 * methods implement "chaining".</p>
 */
public class ChainingMenu extends JMenu {

    int maxItems = 20;

    JMenu currentSubmenu;

    public ChainingMenu(String text) {
	this(text, false);
    }

    public ChainingMenu(String text, boolean isTearOff) {
	super(text, isTearOff);
	currentSubmenu = this;
	maxItems = Parameters.getInt("max-menu-items", maxItems);
    }

    // /\/: We can't override addImpl to catch all additions,
    // because a JMenu calls the add methods of a JPopupMenu
    // that it contains, and it's the popup-menu's addImpl
    // that is called.

    // /\/: getItemCount calls getMenuComponentCount.
    // Both include separators.

    public JMenuItem add(JMenuItem item) {
	if (currentSubmenu.getItemCount() >= maxItems) {
	    JMenu more = new JMenu("More");
	    addAtEnd(more);
	    currentSubmenu = more;
	}
	addAtEnd(item);
	return item;
    }

    private void addAtEnd(Component comp) {
	if (currentSubmenu == this)
	    super.add(comp);
	else
	    currentSubmenu.add(comp);
    }

    public void addSeparator() {
	if (currentSubmenu == this)
	    super.addSeparator();
	else
	    currentSubmenu.addSeparator();
    }

}
