/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 16 23:30:03 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.icore.plan.build;

import java.util.*;

import ix.icore.*;
import ix.icore.plan.*;
import ix.util.*;

import ix.test.PlanBuilderTest;

/**
 * Plan-construction utility.  This class is only a minor
 * variation on {@link ExamplePlanBuilder}.  They have the
 * same functionality and share most of their methods,
 * but this class uses a simpler, but less abstract, way
 * of building issue and activity expansions.
 */
public class SimplePlanBuilder extends ExamplePlanBuilder {

    public SimplePlanBuilder() {}

    public Plan getPlan() {
	    
	// Issues
	walkIssues(issues, planIssues, null);

	// Activities
	walkActivities(activities, planNodes, null);

	// Fill in the plan
	fillInPlan();

	return plan;

    }

    protected void walkIssues(List issues, List planIssues, PlanIssue parent) {
	for (Iterator i = issues.iterator(); i.hasNext();) {
	    Issue issue = (Issue)i.next();
	    List children = getSubitems(issue);
	    String idBase = 
		parent == null ? "issue" : parent.getId().toString();
	    PlanIssue pi = new PlanIssue(genId(idBase), issue);
	    planIssues.add(pi);
	    if (children != null)
		buildExpansion(pi, children);
	}
    }

    protected void buildExpansion(PlanIssue pi, List children) {

	// Construct the refinement that will describe the
	// expansion of the issue.
	PlanIssueRefinement ref = new PlanIssueRefinement();
	ref.setId(genId("issue-refinement"));
	issueRefinements.add(ref);

	// Connect the plan-issue and the refinement.
	pi.setExpansion(ref.getId());
	ref.setExpands(pi.getId());

	// Visit children
	ListOfPlanIssue childPlanIssues = new LinkedListOfPlanIssue();
	ref.setPlanIssues(childPlanIssues);
	walkIssues(children, childPlanIssues, pi);

	Debug.expect(childPlanIssues.size() == children.size());
    
    }

    protected void walkActivities(List activities, List planNodes,
				  PlanNode parent) {
	for (Iterator i = activities.iterator(); i.hasNext();) {
	    Activity act = (Activity)i.next();
	    List children = getSubitems(act);
	    String idBase = 
		parent == null ? "node" : parent.getId().toString();
	    PlanNode node = new PlanNode(genId(idBase), act);
	    planNodes.add(node);
	    if (children != null)
		buildExpansion(node, children);
	}
    }

    protected void buildExpansion(PlanNode node, List children) {

	// Construct the refinement that will describe the
	// expansion of the node.
	PlanRefinement ref = new PlanRefinement();
	ref.setId(genId("refinement"));
	planRefinements.add(ref);

	// Connect the node and the refinement.
	node.setExpansion(ref.getId());
	ref.setExpands(node.getId());

	// Visit children
	ListOfPlanNode childNodes = new LinkedListOfPlanNode();
	ref.setPlanNodes(childNodes);
	walkActivities(children, childNodes, node);

	Debug.expect(childNodes.size() == children.size());

    }

    /**
     * Main program for testing.  Makes a {@link PlanBuilderTest}
     * and calls {@link PlanBuilderTest#test(PlanBuilder)} on
     * an instance of SimplePlanBuilder.
     */
    public static void main (String[] argv) throws Exception {
	new PlanBuilderTest().test(new SimplePlanBuilder());
    }

}
