/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue May  6 18:51:45 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.*;
import ix.util.*;
import ix.util.lisp.*;

/**
 * A variable that can appear in patterns in a plan.
 *
 * @see PlanVariableDeclaration
 */
public class PlanVariable extends PlanObject {

    protected Name id;
    protected Symbol name;		// really an ItemVar /\/

    public PlanVariable() {
    }

    public PlanVariable(Name id, Symbol name) {
	this.id = id;
	this.name = name;
    }

    public Name getId() {
        return id;
    }

    public void setId(Name id) {
        this.id = id;
    }

    public Symbol getName() {
        return name;
    }

    public void setName(Symbol name) {
        this.name = name;
    }

    public String toString() {
	return "PlanVariable[id=" + id + ", name=" + name + "]";
    }

}
