/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Jul  9 23:05:07 2003 by Jeff Dalton
 * Copyright: (c) 2002, 2003, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;

import ix.icore.*;
import ix.util.Name;

/**
 * Wraps an {@link ix.icore.Issue} when it appears in a plan.
 */
public class PlanIssue extends AbstractPlanItem {

    protected Issue issue;

    public PlanIssue() {
    }

    public PlanIssue(Name id, Issue issue) {
	this.id = id;
	this.issue = issue;
    }

    public Issue getIssue() {
        return issue;
    }

    public TaskItem getItem() {
	return getIssue();
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
    }

    public void setItem(TaskItem item) {
	setIssue((Issue)item);
    }

}
