/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 21 19:30:16 2009 by Jeff Dalton
 * Copyright: (c) 2006, 2009, AIAI, University of Edinburgh
 */

package ix.icore.log;

import org.jdom.Document;

import java.io.*;
import java.util.*;

import ix.iface.util.Reporting;

import ix.ip2.log.*; // bad modularity for this to know about that /\/

import ix.util.*;
import ix.util.xml.*;

// /\/: Should be packaged better.  There should be a class that
// can be used as a utility by things that want to process log files.

public class PrintEventLog {

    private String logFileName;
    private BufferedReader in;
    protected PrintStream out;

    public PrintEventLog() {
	this.out = System.out;
    }

    public static void main(String[] argv) throws Exception {
	Parameters.processCommandLineArguments(argv);
	new PrintEventLog().run();
    }

    protected void processCommandLineArguments() {
	logFileName = Parameters.getParameter("log");
    }

    protected void run() throws Exception {
	processCommandLineArguments();
	InputStream stream = new FileInputStream(logFileName);
	Reader streamReader = new InputStreamReader(stream, "UTF-8");
	in = new BufferedReader(streamReader);
	while (true) {
	    String block = readBlock(in);
	    if (block == null)
		break;
	    block = block.trim();
	    if (block.equals(""))
		continue;
	    HistoryEvent event = (HistoryEvent)XML.objectFromXML(block);
            describeEvent(event);
	}
    }

    private String readBlock(BufferedReader in) {
	String line = readLine();
	if (line == null)
	    return null;
	StringBuffer result = new StringBuffer();
	while (true) {
	    result.append(line);
	    result.append("\n");
	    line = readLine();
	    if (line == null)
		break;
	    if (line.startsWith("</")) {
		result.append(line);
		result.append("\n");
		break;
	    }
	}
	return result.toString();
    }

    private String readLine() {
	try {
	    return in.readLine();
	}
	catch (IOException e) {
	    Debug.displayException(e);
	    return null;
	}
    }

    protected void describeEvent(HistoryEvent event) {
        beginEventDescription(event);
        describeEventByType(event);
        endEventDescription(event);
    }

    protected void beginEventDescription(HistoryEvent event) {
	out.println(event.getDate() + " " + eventClassName(event));
    }

    protected void endEventDescription(HistoryEvent event) {
        out.println("- - - - - - - - - -");
    }

    protected void describeEventByType(HistoryEvent event) {
	if (event instanceof HistoryComment)
	    describeEvent((HistoryComment)event);
	else if (event instanceof MessageSent)
	    describeEvent((MessageSent)event);
	else if (event instanceof MessageReceived)
	    describeEvent((MessageReceived)event);
	else if (event instanceof ItemHandledEvent)
	    describeEvent((ItemHandledEvent)event);
	else if (event instanceof BindingEvent)
	    describeEvent((BindingEvent)event);
    }

    protected String eventClassName(HistoryEvent event) {
	return Strings.afterLast(".", event.getClass().getName());
    }

    protected void describeEvent(HistoryComment event) {
	out.println(" " + event.getContents());
    }

    protected void describeEvent(MessageSent event) {
	out.println(" " + Reporting.description(event.getContents()));
    }

    protected void describeEvent(MessageReceived event) {
	out.println(" " + Reporting.description(event.getContents()));
    }

    protected void describeEvent(ItemHandledEvent event) {
	out.println(" " + event.getPattern());
	out.println(" " + event.getAction());
    }

    protected void describeEvent(BindingEvent event) {
	out.println(" " + event.getBindings());
    }

}
